/**
 * Determines if the application is running in development mode
 * @returns {boolean} True if in development mode
 */
function isDevelopment() {
  return process.env.NODE_ENV !== 'production';
}

/**
 * Conditional logger that only logs in development mode
 */
const logger = {
  log: (...args) => {
    if (isDevelopment()) {
      console.log(...args);
    }
  },
  warn: (...args) => {
    if (isDevelopment()) {
      console.warn(...args);
    }
  },
  error: (...args) => {
    if (isDevelopment()) {
      console.error(...args);
    }
  },
  info: (...args) => {
    if (isDevelopment()) {
      console.info(...args);
    }
  },
  debug: (...args) => {
    if (isDevelopment()) {
      console.debug(...args);
    }
  }
};

module.exports = logger;

